const Sequelize = require("sequelize");
const db = require("../connection");
const Category = require('./category');
const Person = require('./person');

const table = db.define(
  "video",
  {
    id: {
      type: Sequelize.BIGINT(11),
      autoIncrement: true,
      primaryKey: true,
    },
    orignalId: {
      type: Sequelize.STRING(255),
      unique: true,
    },
    categoryId: {
      type: Sequelize.BIGINT(11),
    },
    personId: {
      type: Sequelize.BIGINT(11),
    },
    title: {
      type: Sequelize.STRING(255),
    },
    name: {
      type: Sequelize.STRING(255),
    },
    description: {
      type: Sequelize.STRING(500),
    },
    islamiDate: {
      type: Sequelize.STRING(255),
    },
    viewLink: {
      type: Sequelize.STRING(255),
    },
    contentLink: {
      type: Sequelize.STRING(255),
    },
    iconLink: {
      type: Sequelize.STRING(255),
    },
    thumbnailLink: {
      type: Sequelize.STRING(255),
    },
    fileExtension: {
      type: Sequelize.STRING(255),
    },
  },
  {
    paranoid: true,
    timestamps: true,
    // disable the modification of tablenames; By default, sequelize will automatically
    // transform all passed model names (first parameter of define) into plural.
    // if you don't want that, set the following
    freezeTableName: true,
    // define the table's name
    tableName: "video",
  }
);
table.belongsTo(Category, {as: 'category'});
table.belongsTo(Person, {as: 'person'});

module.exports = table;
