const express = require("express");
const router = express.Router();


const checkAuth = require("../middleware/check-auth");
const controller = require("../controllers/googleDrive_controller");


//checkAuth IS ASSIGNED TO THE ROUTE AS MIDDLEWARE BECAUSE ITS A PROTECTED ROUTE AND MUST PASS TOKEN VERIFICATION

// Get the authentication URL
router.post("/auth/google", checkAuth, controller.authorizeGoogleAuth);
// Handle the redirect from the authentication flow
router.get("/auth/redirect", controller.googleAuthCallback);


router.post("/sync-all-ids-drive", checkAuth, controller.syncAllIdsfromDrive);
//sync data for all ids with their thumbnails
router.post("/sync-drive-from-fresh", checkAuth, controller.syncDriveFromFresh);
//rename file on drive renameFilebyFileId
router.post("/rename_file_from_drive", checkAuth, controller.renameFileFromDriveByFileId);

//Audio
// router.post("/sync-drive-from-fresh-for-MASB-bayan-audio", checkAuth, controller.syncDriveFromFreshForMasbBayanAudio);
// router.post("/sync-drive-from-fresh-for-MASB-asfaar-audio", checkAuth, controller.syncDriveFromFreshForMasbAsfaarAudio);
// router.post("/sync-drive-from-fresh-for-HSSS-asfaar-audio", checkAuth, controller.syncDriveFromFreshForHsssAsfaarAudio);
// router.post("/sync-drive-from-fresh-for-HMAS-bayan-audio", checkAuth, controller.syncDriveFromFreshForHmasBayanAudio);
// router.post("/sync-drive-from-fresh-for-HMAS-asfaar-audio", checkAuth, controller.syncDriveFromFreshForHmasAsfaarAudio);
// router.post("/sync-drive-from-fresh-for-HMMS-bayan-audio", checkAuth, controller.syncDriveFromFreshForHmmsBayanAudio);
// router.post("/sync-drive-from-fresh-for-HMMS-asfaar-audio", checkAuth, controller.syncDriveFromFreshForHmmsAsfaarAudio);

//ALL Ashar
router.post("/sync-drive-for-ashaar-audio", checkAuth, controller.syncDriveFromFreshForAllAshaar);
//All Asfaar Bayanaat
router.post("/sync-drive-for-asfaar-audio", checkAuth, controller.syncDriveFromFreshForAllAsfaarBayanaat);
//All books
router.post("/sync-drive-for-all-book", checkAuth, controller.syncDriveFromFreshForAllBook);
//All Video
router.post("/sync-drive-for-all-video", checkAuth, controller.syncDriveFromFreshForAllVideo);
//Molana Abid Shah SB DB bayanaat
router.post("/sync-drive-for-MASS-bayan-audio", checkAuth, controller.syncDriveFromFreshForAllMASSBayanaat);
//All bayanaat
router.post("/sync-drive-for-All-bayan-audio", checkAuth, controller.syncDriveFromFreshForAllBayanaat);



//Pdf
router.post("/sync-drive-from-fresh-for-HMAS-eng-pdf", checkAuth, controller.syncDriveFromFreshForHmasEngPdf);
router.post("/sync-drive-from-fresh-for-HMAS-urdu-pdf", checkAuth, controller.syncDriveFromFreshForHmasUrduPdf);
router.post("/sync-drive-from-fresh-for-HMMS-eng-pdf", checkAuth, controller.syncDriveFromFreshForHmmsEngPdf);
router.post("/sync-drive-from-fresh-for-HMMS-urdu-pdf", checkAuth, controller.syncDriveFromFreshForHmmsUrduPdf);

//Short Video
router.post("/sync-drive-from-fresh-for-HMAS-svideo", checkAuth, controller.syncDriveFromFreshForHmasShortVideo);
router.post("/sync-drive-from-fresh-for-MASB-svideo", checkAuth, controller.syncDriveFromFreshForMasbShortVideo);

// not need
router.post("/sync-drive-from-fresh-for-thumbnail", checkAuth, controller.syncDriveFromFreshForThumbnail);

router.post("/get_by_id/:id", checkAuth, controller.getById);
router.delete("/delete/:id", checkAuth, controller.delete);
router.put("/update/:id", checkAuth, controller.update);

module.exports = router;
