const express = require("express");
const router = express.Router();


const checkAuth = require("../middleware/check-auth");
const personController = require("../controllers/person_controller");


//checkAuth IS ASSIGNED TO THE ROUTE AS MIDDLEWARE BECAUSE ITS A PROTECTED ROUTE AND MUST PASS TOKEN VERIFICATION
router.post("/post",  checkAuth,  personController.post);
router.post("/get_by_limit",  checkAuth,  personController.getByLimit);
router.post("/get_all_admin",  checkAuth,  personController.getAll);
router.post("/get_by_id/:id",  checkAuth,  personController.getById);
router.delete("/delete/:id",  checkAuth,  personController.delete);
router.put("/update/:id",  checkAuth,  personController.update);

router.post("/get_by_type",    personController.getByType);
router.post("/get_all",    personController.getAll);

module.exports = router;
 